; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;
; ** 30-Aug-07 NEHolt; option for unused core/conductors - strip off leading white spaces
;     on extracted core/color string before testing for match. Otherwise could result in 
;     failure to match and cause extra entries to be marked as unused spares.
; ** 12-Jun-06 NEHolt; added option to include unused cable core/conductor entries
; ** 28-Apr-04 LeeH; added support for localized 'wdw' file access messages.
; 26-Sep-03 Mauro Sist globalized
; ** 02-Jul-01 NEHolt N8 Solutions, Inc / VIA Development. Created 
;    as sample post-process util
; ---------  C A B L E C O N . L S P  -----------------------------
; Post-process Wire from/to report. 
;
; This routine is called from AutoCAD Electrical's "User post" button on the
; Cable From/To report dialog display. Report data is passed to this
; routine in AutoLISP variable called "wd_rdata". This utility can
; then operate on this report data, reformat it into a new list of
; report data "rtrn" and then pass it back to AutoCAD Electrical's report dialog 
; through a call to (c:wd_rtrn_2wd rtrn) shown at the end of this file.
;
; -- Structure of the "wd_rdata" list of lists passed from WD:
;
; (list (list <report line1 data>) (list <report line2 data>) ... )
; where each line data sublist consists of a list of the following:
; 0 = wire number
; 1 = LOC for "from" device
; 2 = TAG ID for "from" device
; 3 = terminal PIN number for "from" device connection
; 4 = LOC for "to" device
; 5 = TAG ID for "to" device
; 6 = terminal PIN number for "to" device connection
; 7 = WIRELAY for wire touching "from" device
; 8 = WIRELAY for wire touching "to" device
; 9 = line ref of "from" device
; 10= line ref of "to" device
; 11= SHEET number for "from" device
; 12= SHEET number for "to" device
; 13= cable marker - TAG ID (if cable marker present in wire)
; 14= cable marker - conductor color/number value
; 15= cable marker - LOC code
; 16= cable marker - MFG part number assignment
; 17= cable marker - CAT part number assignment
; 18= cable marker - ASSYCODE part number assignment
; 19= cable marker - catalog lookup DESC field value
; 20= cable marker - catalog lookup QUERY1 field value
; 21= cable marker - catalog lookup QUERY2 field value
; 22= cable marker - catalog lookup MISC1 field value
; 23= cable marker - catalog lookup MISC2 field value
; 24= cable marker - catalog lookup USER1 field value
; 25= cable marker - catalog lookup USER2 field value
; 26= cable marker - catalog lookup USER3 field value
; 27= cable marker - DESC1 description value assignment
; 28= cable marker - DESC2
; 29= cable marker - DESC3
; 30= cable marker - 1=parent marker, 2=child marker
; 31= TAG:PIN - combined "from" device text consisting of TAG ID and PIN number
; 32= TAG:PIN - combined "to" device text consisting of TAG ID and PIN number
; 33= SEC assignment for drawing with "from" device
; 34= SUBSEC assignment for drawing with "from" device
; 35= SEC assignment for drawing with "to" device
; 36= SUBSEC assignment for drawing with "to" device
; 37= INST assignment of "from" device
; 38= INST assignment of "to" device
; 39= IEC style name for "from" device
; 40= IEC style name for "to" device
; 41= TERMDESC value of "from" device wire connection point
; 42= TERMDESC value of "to" device wire connection point
; 43= wire connection sequence code for "from" device wire connection
; 44= wire connection sequence code for "to" device wire connection
; 45= PNLWDLEV1
; 46= PNLWDLEV2
; 47= CMPHDL1 = handle of the "from" component
; 48= CMPHDL2 = handle of the "to" component
; 49= DWGIX1 = the "from" component's drawing index number
; 50= DWGIX2 = the "to" component's drawing index number
; 51= DWGNAM1 = the %D drawing name value of the "from" drawing
; 52= DWGNAM2 = the %D drawing name value of the "to" drawing
; 53= handle of the cable marker
; 54= INST of the cable marker
; 55= CBLDWGIX drawing index number of the cable marker
; 56= entity name of the connected wire on "from" component
; 57= entity name of the connected wire on "to" component
; 58= wire connection direction of "from" component wire connection
; 59= wire connection direction of "to" component wire connection
; 60-62 = X,Y,Z of any associated "from" panel layout wire connection
; 63= "from" panel footprint representation wire connection direction
; 64-66 = X,Y,Z of any associated "to" panel layout wire connection
; 67= "to" panel footprint representation wire connection direction
; 68 = estimated wire length based upon 60-62 and 64-66
; 69= WIRECOLOR1
; 70= WIRESIZE1
; 71-90 USER1_1 through USER1_20
; 91= WIRENUM1
; 92= WIRECOLOR2
; 93= WIRESIZE2
; 94-113= USER2_1 through USER2_20
; 114= WIRENUM2


(defun _wd_post_main ( / rtrn dclnam dcl_id user_1 user_2 user_3 cancel xx wlay1
                         lay_map_lst data wd_make_dcl wd_nth_subst newlst new_lst
                         x ix ixx cat_combo_core_lst cat_combo_lst core_hdls_in_use_lst
                         cores_in_use_lst cores_available_lst lst n parent parent_lst
                         slen val wlay2 parent_hdl_dwgix_lst cat_core_data cable_data
                         _lst hit doing_cbl_hdl this_parent_data _wd_rdata
                         inst inst_lst ix inst1 inst2 lst n newlst picked
                         picked_inst_lst cableinst slen val wlay2 core_color_str)

  ; -- internal subroutines
  (defun wd_nth_subst ( n val lst / newlst ix slen x )
    ; Substitute the nth member of a list "lst" with new value "val"
    ; If "n" is past end of existing list then blank positions "nil" padded
    (if (not lst)
      (setq slen 0)
      (setq slen (length lst))
    )
    (cond
      ((minusp n)  ) ; rtrn orig list if pos is neg number
      ((zerop n) (setq lst (cons val (cdr lst)))) ; n=0, replace 1st item
      ((= n slen) (setq lst (append lst (list val)))) ; new last item
      ((< n slen) ; Insert item somewhere else in list
        (setq ix 0)
        (setq newlst '())
        (foreach x lst
          (if (/= ix n)
            (setq newlst (cons x newlst)) ; reuse existing
            (setq newlst (cons val newlst)) ; substitute new
          )
          (setq ix (1+ ix))
        )
        (setq lst (reverse newlst))
        (setq newlst nil)
      )
      ((> n slen) ; lengthen list, add "nil" pads as req'd
        (setq lst (reverse lst))
        (while (< slen n)
          (setq lst (cons nil lst))  ; add pads
          (setq slen (1+ slen))
        )
        (setq lst (reverse (cons val lst))) ; tack new item on end
    ) )
   lst
  )                         
  ; -- main routine --
  (setq rtrn nil)
  ; AutoCAD Electrical passes the report displayed data as a list of lists of lists in variable
  ; called wd_rdata. The first element of this list is the list of lists
  ; report data. The 2nd element is future (at this time).
  (if (AND wd_rdata (car wd_rdata) (listp (car wd_rdata)))
    (setq wd_rdata (car wd_rdata))) ; just go with first list of lists (report data)

;  (setq user_1 "1") ; default to 1st user entry toggled on  
  (setq user_1 "0") ; default toggle OFF
  (setq user_2 "0")
  (setq user_3 "0")
  ; Look for dcl file of same name, open if found.
  (setq cancel nil)
  (if (setq dclnam (c:ace_find_file "cablecon.dcl" 16)) ; 16=display error dialog if file not found
    (progn
      (setq dcl_id (load_dialog dclnam))                
      (if (new_dialog "main_select" dcl_id)
        (progn
          (set_tile "user1" user_1) ; preset toggle ON
          (action_tile "user1" "(setq user_1 $value)")
          (action_tile "user2" "(setq user_2 $value)")
          (action_tile "user3" "(setq user_3 $value)")
          (action_tile "cancel" "(setq cancel 1)")
          (start_dialog)
          (unload_dialog dcl_id)
  ) ) ) )

  (if (AND wd_rdata (not cancel))
    (progn ; user didn't cancel out of dialog, okay to continue  
      (if (= user_1 "1") ; Do substitution of color/gauge labels for layer names
        (progn
          ; Read current Wire layer mapping file (".wdw" file)
          (setq x (c:wd_find_wdw))
; ** 28-Apr-04.sn LeeH
;;          (if (/= x nil)(princ (strcat "\n"
;;                                       ;|cablecon_dcl_010|;"Reading wdw: "
;;                                       x)))
          (if (/= x nil)(princ (strcat "\n" (c:wd_msg "WLAY029" nil "Reading wdw") ": " x)))
; ** 28-Apr-04.en
          (setq lay_map_lst (c:wd_read_wdw x))
          (if (not lay_map_lst)
; ** 28-Apr-04.sn LeeH
;;            (progn ; ".wdw" mapping file not found
;;              (princ
;;                (strcat "\n "
;;                        ;|cablecon_dcl_011|;".WDW\" mapping file not found")
;;            ) )
              (princ (strcat "\n \".WDW\"" (c:wd_msg "WLAY030" nil "mapping file not found")))
; ** 28-Apr-04.en
          ; ELSE
            (progn ; found it, continue processing the report data
              ; CABLECON report data has wire layer fields as 8th and 9th elements of each
              ; sublist in the report data (0th element = first element in sublist)        
    
              ; Now process each sublist in the report data list (i.e. each line of report data)  
              (foreach xx wd_rdata
                (setq wlay1 (nth 7 xx)) ; existing report wire layer name "WLAY1"
                (setq wlay2 (nth 8 xx)) ; existing report wire layer name "WLAY2" 
                ; Now look through mapping list and try to find a match on the layer name
                (foreach data lay_map_lst
                  (if (= wlay1 (nth 0 data))
                    ; Match found, grab new substitute text string to use
                    (setq wlay1 (nth 1 data)))
                  ; Check the other layer entry  
                  (if (= wlay2 (nth 0 data))
                    ; Match found
                    (setq wlay2 (nth 1 data)))
                )     
                ; Now check to see if match found for either entry. If so, substitute new
                ; value into the sublist
                (if (/= wlay1 (nth 7 xx)) 
                  (progn ; Yes, WLAY1 value needs to be updated
                    (setq xx (wd_nth_subst 7 wlay1 xx))
                  )
                )
                (if (/= wlay2 (nth 8 xx))
                  (progn ; Yes, WLAY2 value needs to be updated
                    (setq xx (wd_nth_subst 8 wlay2 xx))
                  )
                )
                ; Now added the sublist back into the new version of the list
                (setq rtrn (cons xx rtrn))
              )
              ; The new list will be reversed from original. Flip back.
              (setq rtrn (reverse rtrn)) 
              (setq wd_rdata rtrn) ; fresh copy for possible further processing 
            )       
        ) )
      )    
      (if (= user_2 "1")
        (progn
; ** 26-Mar-06 NEHolt        
          ; Go through data and create a list of INST values on end devices and
          ; on cable marker itself.
          (setq inst_lst nil)
          (foreach xx wd_rdata
            (setq inst1 (nth 37 xx))
            (if (= inst1 "")(setq inst1 "(??)"))
            (if (not (member inst1 inst_lst))
              ; This INST1 not in list, add it now
              (setq inst_lst (cons inst1 inst_lst)))
            (setq inst2 (nth 38 xx))
            (if (= inst2 "")(setq inst2 "(??)"))  
            (if (not (member inst2 inst_lst))
              ; This INST2 not in list, add it now
              (setq inst_lst (cons inst2 inst_lst)))
            (setq cableinst (nth 54 xx)) ; INST marking on cable marker itself
            (if (= cableinst "")(setq cableinst "(??)"))  
            (if (not (member cableinst inst_lst))
              ; This INST not in list, add it now
              (setq inst_lst (cons cableinst inst_lst)))
          )
          (if (AND inst_lst (> (length inst_lst) 1))
            (progn ; two or more INST values, display in a multi-select pick list dialog
              (setq dcl_id (load_dialog dclnam))                
              (if (not (new_dialog "inst_select" dcl_id))
                ; Could not find definition for this INST list dialog
                (alert (strcat (c:wd_msg "GEN075" (list "inst_select") "%1 not found") "\n(" dclnam ")"))
              ; ELSE
                (progn ; display INST list in pick-list dialog
                  (setq cancel nil)
                  ; Sort the list alphabetically
                  (setq inst_lst (acad_strlsort inst_lst))
                  ; Now display in pick list dialog
                  (start_list "instlst")
                  (mapcar 'add_list inst_lst)
                  (end_list)
                  ; Define action for pick list dialog
                  (action_tile "instlst" "(setq picked $value)")
                  ; Define action for "Cancel" button
                  (action_tile "cancel" "(setq cancel 1)")
                  (start_dialog)
                  (unload_dialog dcl_id)
                  ; Return from dialog as it is dismissed
                  (if (AND (not cancel) picked)
                    (progn ; user picked one or more INST codes. Index numbers returned
                           ; in string "picked", space delimited. Break this down and
                           ; assemble a list of the picked INST values.
                      (setq lst (c:wd_delim_str_to_lst picked " "))
                      (setq picked_inst_lst nil)
                      (foreach xx lst
                        (setq inst (nth (atoi xx) inst_lst)) ; retrieve actual INST text value
                        (if (= inst "(??)") (setq inst "")) ; flip the blank flag to actual blank
                        (setq picked_inst_lst (cons inst picked_inst_lst))
                      )
                      ; Now have list of valid INST values in "picked_inst_lst". Go 
                      ; through the From/To data and filter out all entries that do NOT
                      ; have an INST1 or INST2 that shows up in the picked INST list.
                      (setq rtrn nil)
                      (foreach xx wd_rdata
                        (if (OR (member (nth 37 xx) picked_inst_lst)
                                (member (nth 38 xx) picked_inst_lst)
                                (member (nth 54 xx) picked_inst_lst))
                          (progn ; OK, this from/to entry includes one of the target INST values
                            (setq rtrn (cons xx rtrn)) ; save it in the output list
                      ) ) )
                      (setq rtrn (reverse rtrn)) ; put back into original order
                      (setq wd_rdata rtrn) ; fresh copy for possible further processing
                ) ) )                 
          ) ) ) 
; ** 26-Mar-06 NEHolt.en          
      ) ) 
      (if (= user_3 "1")
        (progn
          ; First collect all parent cable markers that carry catalog assignments.
          ; Then, for each one of these, query the catalog lookup to pull out the
          ; "core/conductor" color assignment list.
          (setq cat_combo_lst nil)
          (setq cat_combo_core_lst nil)
          (setq parent_hdl_dwgix_lst nil)
          (setq parent_lst nil)
          (setq cable_data nil)
          (foreach xx wd_rdata
            (if (= (AND (nth 30 xx) "1") ; this is a parent with non-blank CAT assignment
                        (/= (nth 17 xx) "")
                        (not (member (list (nth 53 xx)(nth 55 xx)) parent_hdl_dwgix_lst))) ; not repeat
              (progn
                ; Save this parent tag in a list
                (setq parent_lst (cons xx parent_lst))
                (setq parent_hdl_dwgix_lst (cons (list (nth 53 xx) (nth 55 xx)) parent_hdl_dwgix_lst))
               ; Query the catalog _W0_CBLWIRES table for list of core/conductor colors                       
                (if (not (member (list (nth 16 xx) (nth 17 xx)) cat_combo_lst)) ; not already in list
                  (progn
                    ; Check for cable "core/conductor" color list data
                    (setq x (wd_cable_get_cblwires (nth 16 xx) (nth 17 xx)))
                    ; Save all info in parallel lists
                    (setq cat_combo_lst (cons (list (nth 16 xx) (nth 17 xx)) cat_combo_lst))
                    ; x = (list (list core_colors) (list core_sizes))
                    (setq cat_combo_core_lst (cons x cat_combo_core_lst))
                ) )                     
          ) ) )            
          ; For each parent, go through the report and collect all cable wire core/conductor
          ; color assignments for this cable (parent + all child cable marker assignments).
          (foreach parent parent_lst
            ; Check if we have a list of core/conductors for the parent's part number
            (if (setq x (member (list (nth 16 parent)(nth 17 parent)) cat_combo_lst))
              (progn
                (setq ix (- (length cat_combo_lst)(length x)))
                (setq cat_core_data (nth ix cat_combo_core_lst)) 
                (setq cores_available_lst (car cat_core_data)) ; get first sublist, color list
                
                (setq cores_in_use_lst nil)
                (setq core_hdls_in_use_lst nil)
                ; Now cycle through all report data, look for instances of this
                ; cable marker tag (both parent and all child markers). Collect
                ; the core/conductors in use and prepare to output all of them
                ; grouped together.
                (setq _wd_rdata nil)
                (setq this_parent_data nil)
                (foreach xx wd_rdata
                  (if (AND (= (nth 13 xx)(nth 13 parent)) ; match on cable TAG
                           (= (nth 54 xx)(nth 54 parent)) ; match on cable INST
                           (= (nth 15 xx)(nth 15 parent))) ; match on cable LOC
                    (progn ; Save core color
                      ; First remove any leading/trailing white spaces from the core/color text string
                      (setq core_color_str (wd_1_rmv_leading_blnks (wd_1_rmv_trailing_blnks (nth 14 xx))))
                      (if (not (member (nth 53 xx) core_hdls_in_use_lst)) ; not a 2nd instance of same cable marker
                        (progn                    
                          (setq cores_in_use_lst (cons core_color_str cores_in_use_lst))
                          (setq core_hdls_in_use_lst (cons (nth 53 xx) core_hdls_in_use_lst))
                      ) )    
                      (setq this_parent_data (cons xx this_parent_data))
                      ; Remove this used core/conductor from the catalog lookup "available" list
                      (if (setq x (member core_color_str cores_available_lst))
                        (progn ; remove from list (mark it with "nil")
                          (setq ixx (- (length cores_available_lst) (length x)))
                          (setq cores_available_lst (wd_nth_subst ixx nil cores_available_lst))
                    ) ) )                          
                  ; ELSE
                    (progn
                      (setq _wd_rdata (cons xx _wd_rdata))  
                  ) ) 
                )      
                ; Now paste in new report lines for any unused core/conductors for this cable.
                ; New line will be a "child" cable line and will have the parent's TAG, INST,
                ; and LOC values along with the unused cable core/conductor color code.
                (setq new_lst nil)
                (repeat (length parent) 
                  (setq new_lst (cons "" new_lst))
                )
                (setq new_lst (wd_nth_subst 13 (nth 13 parent) new_lst)) ; TAG
                (setq new_lst (wd_nth_subst 15 (nth 15 parent) new_lst)) ; LOC
                (setq new_lst (wd_nth_subst 54 (nth 54 parent) new_lst)) ; INST
                (setq new_lst (wd_nth_subst 30 "2" new_lst)) ; mark as "CHILD" cable marker
                (foreach x cores_available_lst
                  (if x 
                    (progn ; wasn't nil'd out
                      (setq new_lst (wd_nth_subst 14 x new_lst)) ; insert the core/conductor color
                      (setq new_lst (wd_nth_subst 0 "[sp]" new_lst)) ; an indication that this is "spare"
                      (setq this_parent_data (cons new_lst this_parent_data))  
                ) ) )
                (setq this_parent_data (reverse this_parent_data)) ; spares at end of list
                ; Finally, order the cores (pulled from from/to data + any unused spares)
                ; to match the original catalog lookup core listing
                (setq cores_available_lst (car cat_core_data)) ; fresh copy of conductor/core list
                (setq _lst nil)
                (foreach x cores_available_lst
                  (setq hit nil)
                  (setq ix 0)
                  (foreach xx this_parent_data
                    (if xx 
                      (progn ; not already processed
                        (setq core_color_str (wd_1_rmv_leading_blnks (wd_1_rmv_trailing_blnks (nth 14 xx))))
                        (if (= x core_color_str) ; match on core
                          (progn
                            (if (not hit)
                              (progn
                                (setq _lst (cons xx _lst))
                                (setq hit 1)
                                (setq doing_cbl_hdl (nth 53 xx))
                                ; nil this out in list, it has been "processed"
                                (setq this_parent_data (wd_nth_subst ix nil this_parent_data))                                 
                              )                                                      
                            ; ELSE
                              (progn ; this is 2+ match on this color, include if same cable marker hdl
                                (if (= (nth 53 xx) doing_cbl_hdl)
                                  (progn                               
                                    (setq _lst (cons xx _lst))
                                    ; nil this out in list, it has been "processed"
                                    (setq this_parent_data (wd_nth_subst ix nil this_parent_data))                                 
                            ) ) ) )
                    ) ) ) ) 
                    (setq ix (1+ ix))
                    
                  )                  
                )    
                ; Now add in any missed cores, those that didn't show up in the catalog list
                (foreach xx this_parent_data
                  (if xx (setq _lst (cons xx _lst)))
                )
                (setq _lst (reverse _lst)) ; put back into original order
                ; Now paste this entire cable's group of entries back into the overall report
                (setq cable_data (append _lst cable_data))
            ) ) 
            (setq wd_rdata _wd_rdata)
          ) 
          (if cable_data (setq wd_rdata (append cable_data wd_rdata)))
          (setq rtrn wd_rdata)                
      ) ) 
    )  
  )  
  (c:wd_rtrn_2wd rtrn) ; return post-processed list back to AutoCAD Electrical's report dialog
)
; -- the following AUTO-STARTS when this file is "loaded" from within AutoCAD Electrical (i.e.
;    user hits the "User post" button on a report display dialog)
(_wd_post_main) ; run the above program
(princ)
